<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Role;
use Hash;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class ApiController extends Controller
{
    public function checkLogin(Request $request){
        $hasUser = User::where('status' , 1)->where(function($q) use($request){
            return $q->where('email' , $request->email)->orWhere('mobile' , $request->email)->get();
        })->first();
        
        if( $hasUser ){
            if( Hash::check($request->password , $hasUser->password) ){
                return response()->json(['sttaus' => true , 'message' => 'User get successfully' , 'data' => $hasUser] , 200);    
            }else{
                return response()->json(['sttaus' => true , 'message' => 'Wrong username and password' , 'data' => []] , 401);
            }
        }
        return response()->json(['sttaus' => true , 'message' => 'Wrong username and password' , 'data' => []] , 401);
    }
    
    public function generateQrCode($data)
    {
        $qrCodeBase64 = base64_encode(QrCode::format('png')->size(200)->generate($data));
        return "data:image/png;base64," . $qrCodeBase64;
    }
    
    
}